#include "hal_base.h"
#include "hal_gpio.h"


hal_status_t status;	// պִзֵ״̬

/* ʼPB0 CLKOţʹCLOCK */
void GPIO_init(void)
{
	gpio_init_t init;

	init.io = GPIO_OUTPUT;
	init.level = GPIO_LOW_LEVEL;
	init.mode = GPIO_DIGIT_MODE;
	init.pu = DISABLE;
	init.pd = DISABLE;
	init.drive = GPIO_LOW_DRIVER;
	init.od = DISABLE;
	gpio_init(PB_TYPE, GPIO_PIN_0, &init);
}

/* CLOCKΪHRC, 2Ƶ8MHZ */
void test1(void)
{
	clock_init(CLOCK_SRC_HRC, CLOCK_DIV_2, ENABLE);
}

/* CLOCKΪHRC, 4Ƶ4MHZ */
void test2(void)
{
	clock_init(CLOCK_SRC_HRC, CLOCK_DIV_4, ENABLE);
}

/* CLOCKΪHRC, 8Ƶ2MHZ */
void test3(void)
{
	clock_init(CLOCK_SRC_HRC, CLOCK_DIV_8, ENABLE);
}

/* CLOCKΪLRC, Ƶ32KHZ */
void test4(void)
{
	clock_init(CLOCK_SRC_LRC, CLOCK_DIV_1, ENABLE);
	delay(100);
	clock_init(CLOCK_SRC_HRC, CLOCK_DIV_1, ENABLE);
}

void main() 
{
	// RAMʼ
	ram_clear();
	//ι
	CLRWDT();
	// GPIOʼ
	GPIO_init();
	// clockʼѡHRC,Ƶʹclock 
	status = clock_init(CLOCK_SRC_HRC, CLOCK_DIV_1, ENABLE);

	/* Դ16M CLOCKл8M CLOCK
	   ע⣺²ѡһcasecaseע͵ */
	test1();

	/* Դ16M CLOCKл4M CLOCK */
	//test2();

	/* Դ16M CLOCKл2M CLOCK */
	//test3();

	/* Դ16M CLOCKл32KHZ CLOCK
	   ʱһʱл16M CLOCK */
	//test4();

	while (1) {
		// ι
		CLRWDT();
	}
}